---------------------------------------------
--- EL PUZLE DE JESUS (BOLONIA)
-----------------------------------------------------
-- representacim de fichas con listas de coordenadas
-----------------------------------------------------

type Cuadro  = (Int,Int)
type Ficha  = [Cuadro]
type Fichas = [ Ficha ]
type Hueco  = Cuadro
type Huecos = [Hueco]
data Configuracin = C ( Huecos, Fichas ) deriving Show

-- arreglar la visualizacin

type Direccion = (Int,Int)
instance Eq Configuracin where
  C (hs,fs) == C (hs',fs') = hs === hs' && c
	 where (c,_) = contenidoYresto fs fs'
               [x,u] === [ x',u'] = x==x' && u==u' || x==u' && u==x'
	

vecinasYDireccionesDe		:: Huecos -> [(Cuadro, Direccion)]
vecinasYDireccionesDe hs = [( (x,y), d) |	(x',y') <- hs,
	d <- [(0,1),(0,-1),(1,0),(-1,0)], 
	let (ix,iy)=d,
	let x = x'+ix, 1<=x, x<=5,
	let y = y'+iy, 1<=y, y<=4 ]

fichaDeYRestoDeFichas	:: Cuadro -> Fichas -> (Ficha,Fichas)
fichaDeYRestoDeFichas  c (f:fs)
  | c `elem` f      = (f,fs)
  | otherwise       = (f',f:fs')
  where (f',fs') = fichaDeYRestoDeFichas c fs

desplazaFichaSegn		:: Ficha -> Direccion -> Ficha
desplazaFichaSegn f (ix,iy) = map (\(u,v) -> (u-ix,v-iy)) f

mueveFicha ::  Ficha -> Direccion -> Huecos -> [(Huecos,Ficha)]
mueveFicha f d hs = [ (hs',f') | let f' = desplazaFichaSegn f d,
				  let (e,hs') = contenidoYresto f' (hs++f),
				  e ]

instance Grafo Configuracin where
  suc (C (hs,fs)) = [ C (hs',f':fs') |(c,d) <- vecinasYDireccionesDe hs,
				c `notElem` hs,
				let (f,fs')     =  fichaDeYRestoDeFichas c fs,
				(hs',f')    <-     mueveFicha f d hs ]

mueveFichaAHuecoConHuecos  :: Ficha -> Cuadro -> Huecos -> [ (Huecos, Ficha) ]
mueveFichaAHuecoConHuecos f d hs = 
	[ (hs',f') | let f' =  desplazaFichaSegn f d, 
		     let (e,hs') = contenidoYresto f' (hs++f),
		     e ]

estaYresto _  []     = (False, [])
estaYresto x  (y:ys)
   | x == y            = (True, ys)
   | otherwise         = (e, y:ys') where (e,ys') = estaYresto x ys

contenidoYresto []     ys  = (True,ys)
contenidoYresto (x:xs) ys  = (e&&c, ys') 
	where 	(e,rs) = estaYresto x ys
		(c,ys')= contenidoYresto xs rs


---------------------------------------------
-- LA CLASE Grafo ( Busqueda en profundidad ) limitando el nmero de pasos
---------------------------------------------
class (Eq a) => Grafo a where
  vertices        :: [a]
  suc             :: a -> [a]
  (</-)           :: a -> [a] -> Bool
  caminoDesde    :: Int         -> -- longitud mxima del camino
                     a           -> -- origen
                     (a -> Bool) -> -- test de encontrado
                     [a]         -> -- vertices ya recorridos
                     [[a]]          -- lista de caminos soluciones
  camino          :: Int -> a -> a -> [ [a] ]
  -- MIEMBROS POR DEFECTO
  x </- ys    = and [ x/=y | y<-ys ]
  camino tope u v = caminoDesde tope u (\x -> x==v) []
  caminoDesde n o te vis
       | n <= 0    = []
       | te o      = [o:vis]
       | otherwise = concat [ caminoDesde (n-1) o' te (o:vis) |
                                         o' <- suc o, not (o' `elem` vis) ]

---------------------------------------------
-- FIN CLASE Grafo
---------------------------------------------

-------------------------------------
-- Configuracin INICIAL ------------
-------------------------------------

cuaInit,v1Init,v2Init,v3Init,v4Init,hInit,p1Init,p2Init,p3Init,p4Init ::  Ficha
cuaInit = [(1,2),(1,3),(2,2),(2,3)]
v1Init  = [(1,1),(2,1)]
v2Init  = [(1,4),(2,4)]
v3Init  = [(4,1),(5,1)]
v4Init  = [(4,4),(5,4)]
p1Init  = [(4,2)]
p2Init  = [(4,3)]
p3Init  = [(5,2)]
p4Init  = [(5,3)]
hInit   = [(3,2),(3,3)]

hsInit :: Huecos
hsInit   = [(3,1),(3,4)]

confInit :: Configuracin
confInit = C (hsInit, fsInit)

fsInit :: Fichas
fsInit = [cuaInit,v1Init,v2Init,v3Init,v4Init,hInit,p1Init,p2Init,p3Init,p4Init]


solucin = caminoDesde 200 confInit test1 []

--test1 = \(_,fs) ->  [(4,2),(4,3),(5,2),(5,3)] `elem` fs
--test1 = \(_,fs) ->  [(3,1)] `elem` fs && [(3,2)] `elem` fs
--test1 = \(_,fs) ->  [(3,1),(3,2)] `elem` fs
--test1 = \(_,fs) ->  [(1,1),(1,2),(2,1),(2,2)] `elem` fs
test1 = \ (C (_,fs)) ->  [(3,4),(4,4)] `elem` fs 


{-

type Sol  = [ Configuracin ]
type Sols = [ Sol ]

instance Show Sols where
  showsPrec _ []			= id
  showsPrec _ (s:ss)                    = shows s . showString otra_solucion . shows ss

instance Show Sol where
  showsPrec _ []			= id
  showsPrec _ (c:cs)                    = shows c . showString desde . shows cs

-}
{-
instance Show Configuracin where
  showsPrec _ (C (hs,f:fs) )            = shows f
-}

desde = '\n':"Desde <--" 
otraSolucin = '\n':"Otra solucion : -->" 

